/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.text.DecimalFormat;

class PinballCanvas
extends Canvas {
    static Dimension d;
    static int lcolor;
    static int rcolor;
    double power = 0.0;
    static int myScore;
    static int tempScore;
    static int multiplyFactor;
    static int ballsUsed;
    static double gravity;
    static double friction;
    static double speedLimit;
    static double staticFriction;
    static Image itemp;
    static Image ptemp;
    static Graphics offscreen;
    static Graphics pscreen;
    double[] paramarray = new double[4];
    static int[] paddlearray;
    static int[] pixelarray;
    static int[] pixelarrayramp;
    static int[] inputarray;
    static int messageCount;
    static String myMessage;
    static shinySphere ball1;
    static shinySphere ball2;
    static shinySphere ball3;
    static shinySphere ball4;
    static shinySphere ball5;
    static shinySphere ball6;
    static DecimalFormat df;
    DecimalFormat dfx;
    static URL url;
    static boolean gateA;
    static boolean gateB;
    static boolean gateC;
    static boolean gateD;
    static boolean gameOver;
    static boolean flagA;
    static boolean flagB;
    static boolean flagC;
    static boolean spotOn;
    static boolean justSet;
    static boolean tiltOn;
    static boolean paused;
    static boolean targetA;
    static boolean targetB;
    static boolean targetC;
    static boolean targetD;
    static boolean targetE;

    public PinballCanvas(int n, int n2) {
        d = new Dimension(n, n2);
    }

    public void reInit(int[] nArray, int[] nArray2) {
        pixelarray = new int[PinballCanvas.d.width * (PinballCanvas.d.height - 20)];
        pixelarrayramp = new int[PinballCanvas.d.width * (PinballCanvas.d.height - 20)];
        System.arraycopy(Pinball.pixels, 0, pixelarray, 0, PinballCanvas.d.width * (PinballCanvas.d.height - 20));
        System.arraycopy(Pinball.pixelsRamp, 0, pixelarrayramp, 0, PinballCanvas.d.width * (PinballCanvas.d.height - 20));
        System.arraycopy(nArray, 0, paddlearray, 0, 8);
        System.arraycopy(nArray2, 0, inputarray, 0, 14);
        speedLimit = 9.9;
        gravity = 0.15;
        staticFriction = 0.6;
        friction = 0.95;
        ball1 = new shinySphere();
        ball2 = new shinySphere();
        ball3 = new shinySphere();
        ball4 = new shinySphere();
        ball5 = new shinySphere();
        ball6 = new shinySphere();
        df = new DecimalFormat("000000000");
        this.dfx = new DecimalFormat("00");
        myMessage = new String("*****  CLICK TO START  *****");
        this.requestFocus();
    }

    public Dimension getMinimumSize() {
        return d;
    }

    public Dimension getPreferredSize() {
        return d;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (Pinball.firstTime) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, 230, 60);
            graphics.setColor(Color.black);
            graphics.drawRect(10, 10, 210, 25);
            graphics.fillRect(10, 10, Pinball.percentLoaded * 2 + 10, 25);
            graphics.drawString(Pinball.progressMessage, 10, 50);
        } else {
            if (itemp == null) {
                itemp = this.createImage(PinballCanvas.d.width, PinballCanvas.d.height);
            }
            offscreen = itemp.getGraphics();
            offscreen.setFont(new Font("TimeRoman", 0, 15));
            if (!paused) {
                ++messageCount;
            }
            if (messageCount % 20 == 0) {
                tiltOn = false;
            }
            if (messageCount < 200) {
                offscreen.setColor(Color.yellow);
                offscreen.fillRect(0, 0, PinballCanvas.d.width, 20);
                offscreen.setColor(Color.black);
                offscreen.drawString(myMessage, 10, 15);
            } else {
                offscreen.setColor(Color.black);
                offscreen.fillRect(0, 0, PinballCanvas.d.width, 20);
                offscreen.setColor(Color.darkGray);
                offscreen.drawString("BALL 8  MULT x88  SCORE: 888888888", 5, 15);
                offscreen.setColor(Color.yellow);
                if (myScore > 999999999) {
                    myScore = 999999999;
                    myMessage = new String("SCORE FLIPPED, GET A LIFE!!!");
                    if (Pinball.soundOn) {
                        Pinball.tilt.play();
                    }
                    gameOver = true;
                    messageCount = 0;
                }
                offscreen.drawString("BALL " + ballsUsed + "  MULT x" + this.dfx.format(multiplyFactor) + "  SCORE: " + df.format(myScore), 5, 15);
            }
            offscreen.drawImage(Pinball.itable, 0, 20, this);
            offscreen.setColor(Color.black);
            offscreen.fillRect(PinballCanvas.d.width - 14, PinballCanvas.d.height - 70, 6, (int)(3.0 * this.power));
            if (gameOver && messageCount % 20 == 0) {
                gateA = !gateA;
                gateB = !gateA;
                gateC = gateA;
                flagA = !gateA;
                flagB = gateA;
                flagC = !gateA;
                spotOn = gateA;
            }
            if (!gateA) {
                offscreen.drawImage(Pinball.icover, inputarray[0], inputarray[1], this);
            }
            if (!gateB) {
                offscreen.drawImage(Pinball.icover, inputarray[2], inputarray[3], this);
            }
            if (!gateC) {
                offscreen.drawImage(Pinball.icover, inputarray[4], inputarray[5], this);
            }
            if (!flagA) {
                offscreen.drawImage(Pinball.icover, inputarray[6], inputarray[7], this);
            }
            if (!flagB) {
                offscreen.drawImage(Pinball.icover, inputarray[8], inputarray[9], this);
            }
            if (!flagC) {
                offscreen.drawImage(Pinball.icover, inputarray[10], inputarray[11], this);
            }
            if (!spotOn) {
                offscreen.drawImage(Pinball.icover, inputarray[12], inputarray[13], this);
            }
            if (!paused) {
                if (PinballCanvas.ball1.displayFlag) {
                    ball1.displayMe();
                }
                if (PinballCanvas.ball2.displayFlag) {
                    ball2.displayMe();
                }
                if (PinballCanvas.ball3.displayFlag) {
                    ball3.displayMe();
                }
                if (PinballCanvas.ball4.displayFlag) {
                    ball4.displayMe();
                }
                if (PinballCanvas.ball5.displayFlag) {
                    ball5.displayMe();
                }
                if (PinballCanvas.ball6.displayFlag) {
                    ball6.displayMe();
                }
            }
            if (lcolor == -256) {
                if (paddlearray[0] != 0) {
                    offscreen.drawImage(Pinball.ilfu, paddlearray[0], paddlearray[1] - 4, this);
                }
                if (paddlearray[4] != 0) {
                    offscreen.drawImage(Pinball.ilfu, paddlearray[4], paddlearray[5] - 4, this);
                }
            } else {
                if (paddlearray[0] != 0) {
                    offscreen.drawImage(Pinball.ilfd, paddlearray[0], paddlearray[1] + 20, this);
                }
                if (paddlearray[4] != 0) {
                    offscreen.drawImage(Pinball.ilfd, paddlearray[4], paddlearray[5] + 20, this);
                }
            }
            if (rcolor == -65281) {
                if (paddlearray[2] != 0) {
                    offscreen.drawImage(Pinball.irfu, paddlearray[2] - 39, paddlearray[3] - 4, this);
                }
                if (paddlearray[6] != 0) {
                    offscreen.drawImage(Pinball.irfu, paddlearray[6] - 39, paddlearray[7] - 4, this);
                }
            } else {
                if (paddlearray[2] != 0) {
                    offscreen.drawImage(Pinball.irfd, paddlearray[2] - 39, paddlearray[3] + 20, this);
                }
                if (paddlearray[6] != 0) {
                    offscreen.drawImage(Pinball.irfd, paddlearray[6] - 39, paddlearray[7] + 20, this);
                }
            }
            graphics.drawImage(itemp, 0, 0, this);
            offscreen.dispose();
        }
    }

    public void handleKeyPressed(char c) {
        paused = false;
        switch (c) {
            case ' ': {
                this.power += 1.0;
                break;
            }
            case 'Z': 
            case 'z': {
                if (lcolor == -256 || gameOver) break;
                if (Pinball.soundOn) {
                    Pinball.flipon.play();
                }
                lcolor = -256;
                if (PinballCanvas.ball1.displayFlag) {
                    ball1.leftOn();
                }
                if (PinballCanvas.ball2.displayFlag) {
                    ball2.leftOn();
                }
                if (PinballCanvas.ball3.displayFlag) {
                    ball3.leftOn();
                }
                if (PinballCanvas.ball4.displayFlag) {
                    ball4.leftOn();
                }
                if (PinballCanvas.ball5.displayFlag) {
                    ball5.leftOn();
                }
                if (PinballCanvas.ball6.displayFlag) {
                    ball6.leftOn();
                }
                PinballCanvas.toggleGate('F');
                break;
            }
            case '/': {
                if (rcolor == -65281 || gameOver) break;
                if (Pinball.soundOn) {
                    Pinball.flipon.play();
                }
                rcolor = -65281;
                if (PinballCanvas.ball1.displayFlag) {
                    ball1.rightOn();
                }
                if (PinballCanvas.ball2.displayFlag) {
                    ball2.rightOn();
                }
                if (PinballCanvas.ball3.displayFlag) {
                    ball3.rightOn();
                }
                if (PinballCanvas.ball4.displayFlag) {
                    ball4.rightOn();
                }
                if (PinballCanvas.ball5.displayFlag) {
                    ball5.rightOn();
                }
                if (PinballCanvas.ball6.displayFlag) {
                    ball6.rightOn();
                }
                PinballCanvas.toggleGate('D');
                break;
            }
            case 'X': 
            case 'x': {
                if (PinballCanvas.ball1.displayFlag) {
                    ball1.nudge('L');
                }
                if (PinballCanvas.ball2.displayFlag) {
                    ball2.nudge('L');
                }
                if (PinballCanvas.ball3.displayFlag) {
                    ball3.nudge('L');
                }
                if (PinballCanvas.ball4.displayFlag) {
                    ball4.nudge('L');
                }
                if (PinballCanvas.ball5.displayFlag) {
                    ball5.nudge('L');
                }
                if (PinballCanvas.ball6.displayFlag) {
                    ball6.nudge('L');
                }
                if (!tiltOn) break;
                if (Pinball.soundOn) {
                    Pinball.tilt.play();
                }
                myMessage = new String("##### TILT #####");
                messageCount = 0;
                this.handleKeyPressed('k');
                tiltOn = false;
                break;
            }
            case '.': {
                if (PinballCanvas.ball1.displayFlag) {
                    ball1.nudge('R');
                }
                if (PinballCanvas.ball2.displayFlag) {
                    ball2.nudge('R');
                }
                if (PinballCanvas.ball3.displayFlag) {
                    ball3.nudge('R');
                }
                if (PinballCanvas.ball4.displayFlag) {
                    ball4.nudge('R');
                }
                if (PinballCanvas.ball5.displayFlag) {
                    ball5.nudge('R');
                }
                if (PinballCanvas.ball6.displayFlag) {
                    ball6.nudge('R');
                }
                if (tiltOn && PinballCanvas.ball1.x < PinballCanvas.d.width - 20) {
                    if (Pinball.soundOn) {
                        Pinball.tilt.play();
                    }
                    myMessage = new String("##### TILT #####");
                    messageCount = 0;
                    this.handleKeyPressed('k');
                }
                tiltOn = false;
                break;
            }
            case 'S': 
            case 's': {
                this.handleMouseClick();
                break;
            }
            case '1': {
                myMessage = new String("Left(Z), Right(/), Launch(space), Start(S)");
                messageCount = 0;
                break;
            }
            case '2': {
                myMessage = new String("Nudge Left(X), Nudge Right(.), Pause(P)");
                messageCount = 0;
                break;
            }
            case '3': {
                myMessage = new String("HighScore(H), Default Screen(D), KillBall(K)");
                messageCount = 0;
                break;
            }
            case '4': {
                myMessage = new String("Quit(Q), Info(I), Version(V)");
                messageCount = 0;
                break;
            }
            case 'H': 
            case 'h': {
                myMessage = new String("High Score: " + Pinball.initials + " " + Pinball.highScoreString);
                messageCount = 0;
                break;
            }
            case 'I': 
            case 'i': {
                myMessage = new String("www.errthum.com/troy/pinball");
                messageCount = 0;
                break;
            }
            case 'V': 
            case 'v': {
                myMessage = new String("version 1.6");
                messageCount = 0;
                break;
            }
            case 'D': 
            case 'd': {
                messageCount = 200;
                break;
            }
            case 'P': 
            case 'p': {
                myMessage = new String("game paused, hit any key");
                messageCount = 195;
                paused = true;
                break;
            }
            case 'Q': 
            case 'q': {
                ballsUsed = 4;
            }
            case 'K': 
            case 'k': {
                ball1 = new shinySphere();
                ball2 = new shinySphere();
                ball3 = new shinySphere();
                ball4 = new shinySphere();
                ball5 = new shinySphere();
                ball6 = new shinySphere();
                if (gameOver) break;
                PinballCanvas.killBall(true);
            }
        }
        if (this.power > 19.8) {
            this.power = 19.8;
        }
    }

    public void handleKeyReleased(char c) {
        switch (c) {
            case ' ': {
                if (Pinball.soundOn) {
                    Pinball.launch.play();
                }
                if (PinballCanvas.ball1.displayFlag) {
                    ball1.gameOn(this.power);
                }
                if (PinballCanvas.ball2.displayFlag) {
                    ball2.gameOn(this.power);
                }
                if (PinballCanvas.ball3.displayFlag) {
                    ball3.gameOn(this.power);
                }
                if (PinballCanvas.ball4.displayFlag) {
                    ball4.gameOn(this.power);
                }
                if (PinballCanvas.ball5.displayFlag) {
                    ball5.gameOn(this.power);
                }
                if (PinballCanvas.ball6.displayFlag) {
                    ball6.gameOn(this.power);
                }
                this.power = 0.0;
                break;
            }
            case 'Z': 
            case 'z': {
                if (lcolor == -10198016) break;
                if (Pinball.soundOn) {
                    Pinball.flipoff.play();
                }
                if (PinballCanvas.ball1.displayFlag) {
                    ball1.leftOff();
                }
                if (PinballCanvas.ball2.displayFlag) {
                    ball2.leftOff();
                }
                if (PinballCanvas.ball3.displayFlag) {
                    ball3.leftOff();
                }
                if (PinballCanvas.ball4.displayFlag) {
                    ball4.leftOff();
                }
                if (PinballCanvas.ball5.displayFlag) {
                    ball5.leftOff();
                }
                if (PinballCanvas.ball6.displayFlag) {
                    ball6.leftOff();
                }
                lcolor = -10198016;
                break;
            }
            case '/': {
                if (rcolor == -10223516) break;
                if (Pinball.soundOn) {
                    Pinball.flipoff.play();
                }
                if (PinballCanvas.ball1.displayFlag) {
                    ball1.rightOff();
                }
                if (PinballCanvas.ball2.displayFlag) {
                    ball2.rightOff();
                }
                if (PinballCanvas.ball3.displayFlag) {
                    ball3.rightOff();
                }
                if (PinballCanvas.ball4.displayFlag) {
                    ball4.rightOff();
                }
                if (PinballCanvas.ball5.displayFlag) {
                    ball5.rightOff();
                }
                if (PinballCanvas.ball6.displayFlag) {
                    ball6.rightOff();
                }
                rcolor = -10223516;
                break;
            }
            case '.': {
                if (PinballCanvas.ball1.displayFlag) {
                    ball1.nudge('L');
                }
                if (PinballCanvas.ball2.displayFlag) {
                    ball2.nudge('L');
                }
                if (PinballCanvas.ball3.displayFlag) {
                    ball3.nudge('L');
                }
                if (PinballCanvas.ball4.displayFlag) {
                    ball4.nudge('L');
                }
                if (PinballCanvas.ball5.displayFlag) {
                    ball5.nudge('L');
                }
                if (PinballCanvas.ball6.displayFlag) {
                    ball6.nudge('L');
                }
                tiltOn = true;
                break;
            }
            case 'X': 
            case 'x': {
                if (PinballCanvas.ball1.displayFlag) {
                    ball1.nudge('R');
                }
                if (PinballCanvas.ball2.displayFlag) {
                    ball2.nudge('R');
                }
                if (PinballCanvas.ball3.displayFlag) {
                    ball3.nudge('R');
                }
                if (PinballCanvas.ball4.displayFlag) {
                    ball4.nudge('R');
                }
                if (PinballCanvas.ball5.displayFlag) {
                    ball5.nudge('R');
                }
                if (PinballCanvas.ball6.displayFlag) {
                    ball6.nudge('R');
                }
                tiltOn = true;
            }
        }
    }

    public void handleMouseClick() {
        this.repaint();
        if (gameOver) {
            gameOver = false;
            PinballCanvas.ball1.displayFlag = true;
            if (Pinball.testMode) {
                PinballCanvas.ball2.displayFlag = true;
                PinballCanvas.ball3.displayFlag = true;
                PinballCanvas.ball4.displayFlag = true;
                PinballCanvas.ball5.displayFlag = true;
                PinballCanvas.ball6.displayFlag = true;
            }
            gateA = false;
            gateB = false;
            gateC = false;
            gateD = false;
            flagA = false;
            flagB = false;
            flagC = false;
            spotOn = true;
            justSet = false;
            targetA = false;
            targetB = false;
            targetC = false;
            targetD = false;
            targetE = false;
            multiplyFactor = 1;
            myScore = 0;
            tempScore = 0;
            ballsUsed = 1;
            messageCount = 200;
        }
    }

    public static void killBall(boolean bl) {
        if (!(PinballCanvas.ball1.displayFlag || PinballCanvas.ball2.displayFlag || PinballCanvas.ball3.displayFlag || PinballCanvas.ball4.displayFlag || PinballCanvas.ball5.displayFlag || PinballCanvas.ball6.displayFlag)) {
            if (myScore - tempScore < 500 && !bl) {
                if (Pinball.soundOn) {
                    Pinball.kicker.play();
                }
                myMessage = new String("BALL RELAUNCHED !!!");
                messageCount = 0;
                ball1 = new shinySphere(-19);
                tempScore = myScore - 500;
            } else {
                if (Pinball.soundOn) {
                    Pinball.dead.play();
                }
                if (++ballsUsed > 3) {
                    myMessage = new String("GAME OVER -- CLICK TO RESTART");
                    gameOver = true;
                    messageCount = 0;
                    ballsUsed = 3;
                    if (myScore > Pinball.highScoreInt && Pinball.perlFile != null) {
                        PinballCanvas.popMessage();
                    }
                } else {
                    PinballCanvas.ball1.displayFlag = true;
                    gateA = false;
                    gateB = false;
                    gateC = false;
                    gateD = false;
                    flagA = false;
                    flagB = false;
                    flagC = false;
                    targetA = false;
                    targetB = false;
                    targetC = false;
                    targetD = false;
                    targetE = false;
                    multiplyFactor = 1;
                    spotOn = true;
                }
                tempScore = myScore;
            }
        }
    }

    public static void toggleGate(char c) {
        switch (c) {
            case 'A': {
                if (Pinball.soundOn) {
                    Pinball.chute.play();
                }
                gateA = !gateA;
                myScore += 5 * multiplyFactor;
                break;
            }
            case 'B': {
                if (Pinball.soundOn) {
                    Pinball.chute.play();
                }
                gateB = !gateB;
                myScore += 5 * multiplyFactor;
                break;
            }
            case 'C': {
                if (Pinball.soundOn) {
                    Pinball.chute.play();
                }
                gateC = !gateC;
                myScore += 5 * multiplyFactor;
                break;
            }
            case 'D': {
                gateD = gateC;
                gateC = gateB;
                gateB = gateA;
                gateA = gateD;
                break;
            }
            case 'E': {
                if (Pinball.soundOn) {
                    Pinball.chute.play();
                }
                myScore += multiplyFactor * 100;
                break;
            }
            case 'F': {
                gateD = gateA;
                gateA = gateB;
                gateB = gateC;
                gateC = gateD;
            }
        }
        if (gateA && gateB && gateC) {
            if (Pinball.soundOn) {
                Pinball.chutes.play();
            }
            spotOn = true;
            if (multiplyFactor < 99) {
                ++multiplyFactor;
            }
            gateA = false;
            gateB = false;
            gateC = false;
            gateD = false;
            myScore += 15 * multiplyFactor;
            myMessage = new String("MULTIPLIER INCREASED TO x" + multiplyFactor);
            messageCount = 0;
        }
    }

    public static void setTarget(char c) {
        if (!justSet) {
            justSet = true;
            switch (c) {
                case 'A': {
                    if (Pinball.soundOn) {
                        Pinball.flag.play();
                    }
                    targetA = true;
                    myScore += 5 * multiplyFactor;
                    break;
                }
                case 'B': {
                    if (Pinball.soundOn) {
                        Pinball.flag.play();
                    }
                    targetB = true;
                    myScore += 5 * multiplyFactor;
                    break;
                }
                case 'C': {
                    if (Pinball.soundOn) {
                        Pinball.flag.play();
                    }
                    targetC = true;
                    myScore += 5 * multiplyFactor;
                    break;
                }
                case 'D': {
                    if (Pinball.soundOn) {
                        Pinball.flag.play();
                    }
                    targetD = true;
                    myScore += 5 * multiplyFactor;
                    break;
                }
                case 'E': {
                    if (Pinball.soundOn) {
                        Pinball.flag.play();
                    }
                    targetE = true;
                    myScore += 5 * multiplyFactor;
                }
            }
        }
        if (targetA && targetB && targetC && targetD && targetE) {
            if (Pinball.soundOn) {
                Pinball.flags.play();
            }
            targetA = false;
            targetB = false;
            targetC = false;
            targetD = false;
            targetE = false;
            myScore += 2000 * multiplyFactor;
            myMessage = new String("TARGETS RESET, " + 2000 * multiplyFactor);
            messageCount = 0;
        }
    }

    public static void setFlag(char c) {
        if (!justSet) {
            justSet = true;
            switch (c) {
                case 'A': {
                    if (flagA) break;
                    if (Pinball.soundOn) {
                        Pinball.flag.play();
                    }
                    flagA = true;
                    myScore += 10 * multiplyFactor;
                    break;
                }
                case 'B': {
                    if (flagB) break;
                    if (Pinball.soundOn) {
                        Pinball.flag.play();
                    }
                    flagB = true;
                    myScore += 10 * multiplyFactor;
                    break;
                }
                case 'C': {
                    if (flagC) break;
                    if (Pinball.soundOn) {
                        Pinball.flag.play();
                    }
                    flagC = true;
                    myScore += 10 * multiplyFactor;
                }
            }
        }
        if (flagA && flagB && flagC) {
            if (Pinball.soundOn) {
                Pinball.flags.play();
            }
            flagA = false;
            flagB = false;
            flagC = false;
            myScore += 1000 * multiplyFactor;
            myMessage = new String("FLAGS RESET, " + 1000 * multiplyFactor);
            messageCount = 0;
        }
    }

    public static void sweetSpot() {
        if (spotOn) {
            if (Pinball.soundOn) {
                Pinball.success.play();
            }
            spotOn = false;
            switch (multiplyFactor % 10) {
                case 1: {
                    myScore += multiplyFactor * 1000;
                    myMessage = new String(" " + multiplyFactor * 1000 + " POINTS AWARDED !!!!!");
                    messageCount = 0;
                    break;
                }
                case 2: {
                    myScore = 2 * myScore;
                    myMessage = new String("SCORE IS DOUBLED !!!!!");
                    messageCount = 0;
                    break;
                }
                case 3: {
                    PinballCanvas.multiball(3);
                    myMessage = new String("MULTI - BALL !!!!!");
                    messageCount = 0;
                    break;
                }
                case 4: {
                    myScore += multiplyFactor * 10000;
                    myMessage = new String(" " + multiplyFactor * 10000 + " POINTS AWARDED !!!!!");
                    messageCount = 0;
                    break;
                }
                case 5: {
                    if (--ballsUsed < 0) {
                        ballsUsed = 0;
                        break;
                    }
                    myMessage = new String("FREE BALL !!!!!");
                    messageCount = 0;
                    break;
                }
                case 6: {
                    PinballCanvas.multiball(3);
                    myMessage = new String("MULTI - BALL !!!!!");
                    messageCount = 0;
                    break;
                }
                case 7: {
                    myScore += multiplyFactor * 100000;
                    myMessage = new String(" " + multiplyFactor * 100000 + " POINTS AWARDED !!!!!");
                    messageCount = 0;
                    break;
                }
                case 8: {
                    myScore = 3 * myScore;
                    myMessage = new String("SCORE IS TRIPLED !!!!!");
                    messageCount = 0;
                    break;
                }
                case 9: {
                    PinballCanvas.multiball(6);
                    myMessage = new String("SUPER MULTI - BALL !!!!!");
                    messageCount = 0;
                    break;
                }
                case 0: {
                    if (--ballsUsed < 0) {
                        ballsUsed = 0;
                        break;
                    }
                    myMessage = new String("FREE BALL !!!!!");
                    messageCount = 0;
                }
            }
        }
    }

    public static void multiball(int n) {
        if (n == 3 || n == 6) {
            if (!PinballCanvas.ball1.displayFlag) {
                ball1 = new shinySphere(-19);
            }
            if (!PinballCanvas.ball2.displayFlag) {
                ball2 = new shinySphere(-19);
            }
            if (!PinballCanvas.ball3.displayFlag) {
                ball3 = new shinySphere(-19);
            }
        }
        if (n == 6) {
            if (!PinballCanvas.ball4.displayFlag) {
                ball4 = new shinySphere(-19);
            }
            if (!PinballCanvas.ball5.displayFlag) {
                ball5 = new shinySphere(-19);
            }
            if (!PinballCanvas.ball6.displayFlag) {
                ball6 = new shinySphere(-19);
            }
        }
    }

    public static void popMessage() {
        HighScore highScore = new HighScore(new Frame(""));
        if (highScore.id) {
            System.out.println(highScore.myName.getText());
        }
        try {
            int n = myScore * 9 % 10;
            url = new URL(Pinball.perlFile + "?" + df.format(myScore) + n + "," + highScore.myName.getText());
        }
        catch (Exception exception) {
            System.out.println("url failed");
        }
        highScore.dispose();
    }

    static {
        lcolor = -10198016;
        rcolor = -10223516;
        myScore = 0;
        tempScore = 0;
        multiplyFactor = 1;
        ballsUsed = 1;
        paddlearray = new int[8];
        inputarray = new int[14];
        messageCount = 0;
        gateA = false;
        gateB = false;
        gateC = false;
        gateD = false;
        gameOver = true;
        flagA = false;
        flagB = false;
        flagC = false;
        spotOn = true;
        justSet = false;
        tiltOn = false;
        paused = false;
        targetA = false;
        targetB = false;
        targetC = false;
        targetD = false;
        targetE = false;
    }
}

